<?php

/**
 * RAF & Woocommerce Subscription 
 *
 * @since    3.0.0
 */
$gens_subs = esc_attr(get_option("gens_raf_subscription"));
$is_active = $gens_subs === "1" || $gens_subs === "yes";

if($is_active) {
	add_filter('wcs_new_order_created','gens_renewal_order_created', 10, 2 );
}

function gens_renewal_order_created($order, $subscription)
{
	$gens_use_all_coupons = get_option("gens_raf_subscription_all_coupons");
	$gens_use_all_coupons = $gens_use_all_coupons === "yes" || $gens_use_all_coupons === "1";
	$gens_exclude_shipping = get_option("gens_raf_subscription_exclude_shipping");
	$gens_exclude_shipping = $gens_exclude_shipping === "yes" || $gens_exclude_shipping === "1";
	$partial_use = get_option("gens_raf_subscription_partial_use") === "1";

	$user_id = $order->get_user_id();
	$user_info = get_userdata($user_id);
	$user_email = $user_info->user_email;
	// Prevent empty emails.
	if(empty($user_email)) {
    	return $order;
	}
	// Order Amount
	$order_total = $order->get_total() - $order->get_total_tax();
	if($gens_exclude_shipping) {
		$order_total = $order_total - $order->get_total_shipping() - $order->get_shipping_tax();
	}

	$args = array(
		'posts_per_page'   => 999,
	    'post_type'        => 'shop_coupon',
	    'post_status'      => 'publish',
		'meta_query' => array(
			'relation' => 'AND',
		    array(
			  'key' => 'customer_email',
			  'value' => $user_email,
              'compare' => 'LIKE'
            )
            // Provjeriti da ne povuce kupone koji su istekli
		)
	);
    $coupons = get_posts( $args );
	
	if(empty($coupons)) {
		return $order;
    }
    
    $availableCoupons = [];
    // Get only coupons that havent been used yet:
    foreach($coupons as $coupon) {
        $couponUsage = get_post_meta($coupon->ID,'usage_count', true);
        $usageLimit = get_post_meta($coupon->ID,'usage_limit', true);
        if(($couponUsage < $usageLimit || $usageLimit === '') && substr( $coupon->post_title, 0, 3 ) === "RAF") {
            array_push($availableCoupons, $coupon);
        }
	}
	
	if(empty($availableCoupons)) {
		return $order;
	}

	// If you want to apply all coupons, up to renewal price.
	$total_value = 0;
	foreach ($availableCoupons as $coupon) {
		$coupons_obj = new WC_Coupon($coupon->ID);
		$coupon_amount = $coupons_obj->get_amount();

		// Fix for % amount. Long standing bug.
		$type = strpos($coupons_obj->get_discount_type(), "percent") !== false ? "percent" : "fixed";
		if( $type === "percent") {
			$coupon_amount = $order_total * ( $coupon_amount / 100);
		}

		$total_value = $total_value + $coupon_amount;

		if($total_value >= $order_total) {
			// If its set to use coupon partially.
			if($partial_use && $total_value > $order_total) {
				$coupons_obj->set_amount($total_value - $order_total);
				$coupons_obj->save();
			} else {
				$coupons_obj->set_usage_count($coupons_obj->get_usage_count() + 1);
				$coupons_obj->save();
			}
			break;
		}

		$coupons_obj->set_usage_count($coupons_obj->get_usage_count() + 1);
		$coupons_obj->save();

		// Exit if its not set to use all coupons.
		if(!$gens_use_all_coupons) {
			break;
		}
	}
	// Check to make sure discount is not bigger than order
	if ( $total_value > $order_total ) {
		$total_value = $order_total;
	}
	if($total_value > 0) {
		gens_renewal_order_apply_discount($order, $total_value);
	}
	

    $order_id = ( version_compare( WC_VERSION, '2.7', '<' ) ) ? $order->id : $order->get_id();

    do_action('new_raf_data', 'subscription_renewal', array('user' => $user_id, 'order' => $order_id) );

	return $order;
}

function gens_renewal_order_apply_discount($order,$amount){
	$item = new WC_Order_Item_Fee();
	$item->set_props( array(
	    'name'      => __("Referral applied","gens-raf"),
	    'tax_class' => NULL,
	    'total'     => -$amount,
	    'total_tax' => 0,
	    'tax_status'=> 'none',
	    'order_id'  => $order->get_id(),
	) );
	$item->save();
	$order->add_item( $item );
	$order->update_taxes();
	$order->calculate_totals( true );
}


/**
 * Prevent gens referral code copying during renewals. 
 * https://docs.woocommerce.com/document/subscriptions/develop/filter-reference/
 *
 * @since    2.0.9
 */
function gens_prevent_referral_copying( $order_meta_query, $to_order, $from_order ) {

    $order_meta_query .= " AND `meta_key` NOT IN ('_raf_id', '_wpgens_raf_id', '_raf_meta', '_wpgens_raf_meta')";

    return $order_meta_query;
}
add_filter( 'wcs_renewal_order_meta_query', 'gens_prevent_referral_copying', 10, 3 );