<?php

/**
 * Setup Menu Pages
 * @author    WPGens
 */

if (!defined('ABSPATH')) {
	exit;
}

class WPGENS_RAF_Menu
{

	public function __construct()
	{
		// Add submenu items
		add_action('admin_menu', array($this, 'register_stats_menu'));
		// Add links under plugin page.
		add_filter('plugin_action_links_wpgens-refer-a-friend-premium/wpgens-raf.php', array($this, 'add_settings_link'));
		add_filter('plugin_action_links_wpgens-refer-a-friend-premium/wpgens-raf.php', array($this, 'docs_link'));
	}


	/**
	 * Define submenu page under Woocommerce Page
	 *
	 * @since 2.0.0
	 */
	public function register_stats_menu()
	{
		add_submenu_page('woocommerce', __('WPGENS Refer a Friend', 'gens-raf'), __('Refer a Friend', 'gens-raf'), 'manage_woocommerce', 'gens-raf', array($this, 'display_plugin_react_admin_page'));
	}

	/**
	 * Init the view part.
	 *
	 * @since 2.0.0
	 */
	public function display_plugin_react_admin_page()
	{

		if (defined('GENS_DEV')) {
?>
			<script type="module">
				import RefreshRuntime from "http://localhost:5173/@react-refresh"
				RefreshRuntime.injectIntoGlobalHook(window)
				window.$RefreshReg$ = () => {}
				window.$RefreshSig$ = () => (type) => type
				window.__vite_plugin_react_preamble_installed__ = true
			</script>
			<script type="module" src="http://localhost:5173/@vite/client"></script>
			<script type="module" src="http://localhost:5173/src/main.tsx"></script>
<?php
		}
		echo "<div id='root'></div>";
	}

	/**
	 * Plugin Settings Link on plugin page
	 *
	 * @since 		2.0.0
	 */
	function add_settings_link($links)
	{
		$mylinks = array(
			'<a href="' . admin_url('admin.php?page=gens-raf') . '">Settings</a>',
		);
		return array_merge($links, $mylinks);
	}


	/**
	 * Plugin Documentation Link on plugin page
	 *
	 * @since 		2.0.0
	 */
	function docs_link($links)
	{
		$mylinks = array(
			'<a target="_blank" href="http://wpgens.com/docs">Docs</a>',
		);
		return array_merge($links, $mylinks);
	}
}

new WPGENS_RAF_Menu();
