<?php
/**
 * WPGens RAF Events
 * @author    WPGens
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPGENS_RAF_Events {

	/**
	 * Init the logs part.
	 *
	 * @since 2.0.0
	 */
	public function get_events($curr_page) {
        $per_page = 15;

        $db = new WPGens_RAF_DB();
        $logs = $db->get_by_page($curr_page, $per_page);

        // Pagination
        $total_records = $db->total_records();
        $num_of_pages = ceil($total_records/$per_page);
        
        $formattedLogs = [];
        foreach($logs as $key => $log) {
            $formattedLogs[$key]['type'] = $log['type'];
            $formattedLogs[$key]['type_name'] = $this->get_type_name($log['type']);
            $formattedLogs[$key]['date'] = date('d F Y, h:i:s A', strtotime($log['time'])); 
            $formattedLogs[$key]['info'] = $this->formatEvent($log['type'], $log['id'], $db);
        }

        return array('data' => $formattedLogs, 'num_of_pages' => $num_of_pages);
    }

    public function get_type_name($type) {
        switch($type) {
            case 'coupon_applied':
                return __("Coupon Applied", "gens-raf");
            case 'email_share':
                return __("Email Share", "gens-raf");
            case 'subscription_renewal':
                return __("Subscription Renewal", "gens-raf");
            case 'new_order':
                return 'New Order';
            case 'new_coupon':
                return __("New Coupon Generated", "gens-raf");
            case 'email_sent':
                return __("Email Sent", "gens-raf");
            case 'social_share':
                return __("Social Share", "gens-raf");
            case 'user_referred':
                return __("User Referred", "gens-raf");
        }
    }


	/**
	 * Format Logs meta
	 *
	 * @since 2.0.0
	 */
    public function formatEvent($type, $id, $db){
        switch($type){
            case 'coupon_applied':
                $referral = $db->get_meta($id,'referral');
                if(filter_var($referral, FILTER_VALIDATE_EMAIL)) {
                    $referred_person = 'guest <a href="mailto:'.$referral.'">'.$referral.'</a>.';
                } else {
                    $user_info        = get_userdata($referral);
                    $user_name = $user_info->user_email;
                    $referred_person = '<a href="'.get_edit_user_link($referral).'">'.$user_name.'</a>.';
                }

                return 'Guest coupon successfully applied for a user that was referred by ' .$referred_person;
            case 'email_share':
                $user = $db->get_meta($id,'user');
                $email = $db->get_meta($id,'email');
                $link = $db->get_meta($id,'rafLink');
                $name = $db->get_meta($id,'name') ? $db->get_meta($id,'name') : 'No name specified';
                $user_info = get_userdata($user);
                $user_name = $user_info ? $user_info->first_name.' '.$user_info->last_name : '';
                return 'Sharing via email by <a href="'.get_edit_user_link($user).'">'.$user_name.'</a> to: ('.$name.') '.$email.'. Referral link: '. $link;
            case 'subscription_renewal':
                $user = $db->get_meta($id,'user');
                $order = $db->get_meta($id,'order');
                return 'Applied coupons to automatic subscription renewal order <a href="'.get_edit_post_link($order).'">#'.$order.'</a>.';
            case 'new_order':
                $user = $db->get_meta($id,'user');
                $referral = $db->get_meta($id,'referral');
                $order = $db->get_meta($id,'order');
                $info = $db->get_meta($id,'info');
                $user_info = get_userdata($referral);
                $user_name = $user_info ? $user_info->first_name.' '.$user_info->last_name : 'Guest';
                $person = $user_name === 'Guest' ? 'Guest' : '<a href="'.get_edit_user_link($referral).'">'.$user_name.'</a>';
                return 'New referral <a href="'.get_edit_post_link($order).'">order</a> referred by '.$person.' '.$info;
            case 'new_coupon':
                $user = $db->get_meta($id,'user');
                $order = $db->get_meta($id,'order');
                $coupon = $db->get_meta($id,'coupon_id');
                $user_info = get_userdata($user);
                $user_name = $user_info ? '<a href="'.get_edit_user_link($user).'">'.$user_info->first_name.' '.$user_info->last_name.'</a>' : 'guest';
                return 'New coupon generated and sent to user '.$user_name.'. Coupon was generated for referral order <a href="'.get_edit_post_link($order).'">#'.$order.'</a>.';
            case 'email_sent':
                $coupon_code = $db->get_meta($id,'coupon_code');
                $email = $db->get_meta($id,'email');
                $coupon_id = wc_get_coupon_id_by_code($coupon_code);
                return 'New email sent to '.$email.' containing the rewarded coupon code: <a href="'.get_edit_post_link($coupon_id).'">'.$coupon_code.'</a>.';
             case 'user_referred':
                $user = $db->get_meta($id,'user');
                $referrer = $db->get_meta($id,'referrer');
                $user_info = get_userdata($user);
                $referrer_info = get_userdata($referrer);
                if($user_info) {
                    if($user_info->first_name) {
                        $user_text = $user_info->user_email.' ('.$user_info->first_name.' '.$user_info->last_name.')';
                    } else {
                        $user_text = $user_info->user_email;
                    }
                    $user_name = '<a href="'.get_edit_user_link($user).'">'.$user_text.'</a>';
                } else {
                    $user_name = $user;
                }

                if($referrer_info) {
                    if($referrer_info->first_name) {
                        $user_text = $referrer_info->user_email.' ('.$referrer_info->first_name.' '.$referrer_info->last_name.')';
                    } else {
                        $user_text = $referrer_info->user_email;
                    }
                    $referrer_name = '<a href="'.get_edit_user_link($referrer).'">'.$user_text.'</a>';
                } else {
                    $referrer_name = $referrer;
                }

                return "New referrel registration: ". $user_name.' was referred by '.$referrer_name;
            
        }
    }

}
