<?php

namespace EasyAffiliate\Controllers;

use EasyAffiliate\Caseproof\GrowthTools\App;
use EasyAffiliate\Caseproof\GrowthTools\Config;
use EasyAffiliate\Lib\BaseCtrl;

class GrowthToolsCtrl extends BaseCtrl {
  public function load_hooks() {
    if(version_compare(phpversion(), '7.4', '>=') && class_exists('EasyAffiliate\Caseproof\GrowthTools\App')) {
      add_action('admin_enqueue_scripts', function () {
        $screen = get_current_screen();

        if($screen instanceof \WP_Screen && $screen->id == 'easy-affiliate_page_easy-affiliate-growth-tools') {
          wp_enqueue_style('esaf-onboarding', ESAF_CSS_URL . '/admin-onboarding.css', [], ESAF_VERSION);
        }
      });

      $config = new Config([
        'parentMenuSlug' => 'easy-affiliate',
        'instanceId'     => 'easy-affiliate',
        'menuSlug'     => 'easy-affiliate-growth-tools',
        'buttonCSSClasses' => ['esaf-growth-tools-button'],
      ]);

      new App($config);
    }
  }
}
