<?php

/**
 * Add Meta box to Order Screen
 * @author WPGens
 */

if (!defined('ABSPATH')) {
	exit;
}

class WPGENS_RAF_Order
{

	/**
	 * Hook in order meta boxes and save order meta
	 *
	 * @since 2.0.0
	 */
	public function __construct()
	{
		add_action('woocommerce_order_status_' . apply_filters('wpgens_raf_order_status', 'completed'),  array($this, 'gens_maybe_create_send_coupon'), 10);
	}

	/**
	 * Before version 3, settings field were saved as "yes", after new react admin its "1".
	 */
	public function settings_field_active($field)
	{
		$value = get_option($field);
		if ($value === "yes" || $value === "1") {
			return true;
		}
		return false;
	}

	public function gens_maybe_create_send_coupon($order_id)
	{

		$order = wc_get_order($order_id);
		$raf_meta = $order->get_meta('_raf_meta', true);

		// Already generated? Dont generate again
		// if($order->get_meta( '_raf_coupon_generated', true)) {
		// 	return false;
		// }

		// No referral ID? Exit.
		if (!$order->get_meta('_raf_id', true)) {
			return false;
		}

		// Wrong referral ID? Exit
		$referral_id = $this->get_referral_id($order_id);
		if (!$referral_id) {
			return false;
		}

		// Advocate Coupon (we need to check this way since ppl who update plugin dont have this field yet)
		if (get_option('gens_raf_generate_for_order') !== '') {
			$coupon_object = new WPGens_RAF_Coupons('referrer', $referral_id, $order_id);
			$coupon_code   = $coupon_object->get_coupon(); // returns coupon code

			// Email Coupon Code
			if ($coupon_code && !$this->settings_field_active('gens_raf_disable_emails')) {
				$email = new WPGens_RAF_Email($coupon_object->coupon_mail, $coupon_code, $order_id);
				$email->send_email();
			}

			if ($coupon_code) {
				$order = wc_get_order($order_id);
				$order->update_meta_data('_raf_coupon_generated', true);
				$order->save();
			}
		}

		// Friend Coupon
		if ($this->settings_field_active('gens_raf_friend_enable')) {
			$friend_coupon_object = new WPGens_RAF_Coupons('friend', $referral_id, $order_id);
			$friend_coupon_code   = $friend_coupon_object->get_coupon(); // returns coupon code
		}

		// Email Friend Coupon Code
		if ($this->settings_field_active('gens_raf_friend_enable') && $friend_coupon_code  && !$this->settings_field_active('gens_raf_disable_emails')) {
			$email = new WPGens_RAF_Email($friend_coupon_object->coupon_mail, $friend_coupon_code, $order_id, 'friend');
			$email->send_email();
		}

		// Increase referrals
		if (isset($raf_meta['increase_referrals']) && $raf_meta['increase_referrals'] == "true") {
			WPGens_RAF_User::set_number_of_referrals($referral_id);
		}

		// Mozda vrati coupon pa snimi neku meta.
	}

	public function get_referral_id($order_id)
	{
		$order = wc_get_order($order_id);
		$rafID = esc_attr($order->get_meta('_raf_id', true));
		// Is guest referring?
		if (filter_var($rafID, FILTER_VALIDATE_EMAIL)) {
			return $rafID;
		}
		$gens_users = get_users(array(
			"meta_key" => "gens_referral_id",
			"meta_value" => $rafID,
			"number" => 1,
			"fields" => "ID"
		));
		if (is_array($gens_users) && !empty($gens_users)) {
			return $gens_users[0];
		} else {
			return false;
		}
	}
}
