<?php
/**
 * Handle frontend scripts
 *
 * @since     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WPGens_RAF_Assets {

    /**
     * Hook in methods.
     */
    public static function init() {
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'load_scripts' ) );
        add_action( 'wp_print_scripts', array( __CLASS__, 'localize_printed_scripts' ), 5 );
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts'), 10, 1);
    }

    /**
     * Register/queue frontend scripts.
     */
    public static function load_scripts() {
        wp_enqueue_script( 'gens-raf-js', WPGENS_RAF_URL. 'assets/js/gens-raf-public.js', array( 'jquery' ), WPGENS_RAF_VERSION, false );
        wp_enqueue_style(  'gens-raf', WPGENS_RAF_URL. 'assets/css/gens-raf.css', array(), WPGENS_RAF_VERSION, 'all' );
    }

    /**
     * Register/queue backend scripts.
     */
    public static function admin_enqueue_scripts() {
        $currentScreen = get_current_screen();
        $screenID = $currentScreen->id; //



        if($screenID === "woocommerce_page_gens-raf") {
            
            $formattedCats = array();
            $categories = get_terms('product_cat', ['taxonomy' => 'product_cat', 'hide_empty' => false, 'fields' => 'id=>name']);
            foreach($categories as $key => $cat) {
                $formattedCats[] = array("value" => $key, "label" => $cat);
            }

            $products = get_posts(array('fields' => 'ids', 'numberposts' => 1999, 'post_type' => 'product', 'orderby' => 'title', 'order' => 'ASC'));
            $products = array_map(function ($v) {
                return ['value' => $v, 'label' => get_the_title($v)];
            }, $products);

            wp_enqueue_script( 'gens-raf-backend', WPGENS_RAF_URL. 'includes/admin/assets/js/index.js', array('wp-i18n'), WPGENS_RAF_VERSION, true);
            wp_localize_script( 'gens-raf-backend', 'gens_raf_object', array(
                    'api_nonce'     => wp_create_nonce('wp_rest'),
                    'root'          => rest_url('gens-raf/v1/'),
                    'cats'          => (array)$formattedCats,
                    'products'      => (array)$products,
                    'wpgensBaseurl'   => WPGENS_RAF_URL
                )
            );
        }        
    }

    /**
     * Localise frontend scripts.
     */
    public static function localize_printed_scripts() {
        $time = get_option( 'gens_raf_cookie_time' );
        $cookies = array( 'cookieTime' => $time, 'ajax_url' => admin_url( 'admin-ajax.php' ), 'success_msg' => __('Invitation has been sent!', 'gens-raf') );
        wp_localize_script('gens-raf-js', 'gens_raf', $cookies );
    }
}


WPGens_RAF_Assets::init();