<?php
/**
 * WPGens RAF Events
 * @author    WPGens
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPGENS_RAF_Orders_History {


    public function get_orders($curr_page) {
        $per_page = 20;

		$args = array(
            'meta_key'  => '_raf_id',
			'meta_compare' => 'EXISTS',
            'status' => array_keys( wc_get_order_statuses() ),
            'paged' => $curr_page,
            'limit' => $per_page,
            'return' => 'ids',
            'paginate' => true
        );
        $orders = wc_get_orders( $args );

        // Format Orders
        $formatted_orders = [];
        foreach ($orders->orders as $order) {
            $formatted_orders[] = $this->format_order($order);
        }
        
        return array('data' => $formatted_orders, 'num_of_pages' => $orders->max_num_pages);
	}

	public function format_order($order_id){
		$order = wc_get_order( $order_id );

        $order_info = "<a href='".get_edit_post_link( $order_id )."'>#".$order_id."</a> by ";
        if ( $order->get_user_id() ) {
            $user = $order->get_user();
            $order_info .= "<a href='".get_edit_user_link( $user->ID )."'>".$user->display_name."</a><br/>";
        } else {
            $order_info .= "Guest";
        }

        $referralID = $order->get_meta( '_raf_id', true );	

        if(filter_var($referralID, FILTER_VALIDATE_EMAIL)) {
            $order_referrer = "<a target='_blank' href='mailto:".$referralID."'>".$referralID."</a>";
        } else if (!empty($referralID)) {
            $args = array('meta_key' => "gens_referral_id", 'meta_value' => $referralID );
            $user = get_users($args);
            $order_referrer = "<a href='".get_edit_user_link( $user[0]->ID )."'>".$user[0]->display_name."</a>";	
        }

        return array(
            'order_status' => wc_get_order_status_name($order->get_status()),
            'order_info' => $order_info,
            'order_date' => date_i18n(wc_date_format(), strtotime($order->get_date_created())),
            'order_total' => $order->get_formatted_order_total(),
            'order_referrer' => $order_referrer
        );
	}

}
