<?php

namespace EasyAffiliate\Controllers;

use EasyAffiliate\Lib\Utils;

class NotificationsCtrl
{

  /**
   * Check if user has access and is enabled.
   *
   * @return bool
   */
  public static function has_access() {

    $access = false;

    if (
      Utils::is_admin()
      && ! get_option( 'easyaff_hide_announcements' )
    ) {
      $access = true;
    }

    return apply_filters( 'easyaff_admin_notifications_has_access', $access );
  }
}
